package music;

import art.Artist;

/**
 * Write a description of class Performer here.
 *
 * @author (your name)
 * @version (a version number or a date)
 */
public class Performer extends Musician implements Artist {
    
    private String name;
    private String origin;
    private int age;
    
    public Performer(String name, String origin, int age) {
        this.name = name;
        this.origin = origin;
        this.age = age;
    }
    
    public Performer(String name, String origin) {
        this.name = name;
        this.origin = origin;
    }
    
    public Performer() {
    }
    
	@Override
	public void create() {
		System.out.println("I am playing...");
	}

	@Override
	public void showArtType() {
		System.out.println("Music");
	}

	@Override
	public void describe() {
		System.out.println("Performer");
	}
    
    @Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + age;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		result = prime * result + ((origin == null) ? 0 : origin.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Performer other = (Performer) obj;
		if (age != other.age)
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		if (origin == null) {
			if (other.origin != null)
				return false;
		} else if (!origin.equals(other.origin))
			return false;
		return true;
	}

	public void setName(String name) {
        this.name = name;
    }
    
    public String getName() {
        return this.name;
    }
    
    public void setOrigin(String origin) {
        this.origin = origin;
    }
    
    public String getOrigin() {
        return this.origin;
    }
    
    public void setAge(int age) {
        this.age = age;
    }
    
    public int getAge() {
        return this.age;
    }

}
